package cn.ibizlab.util.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ApiModel("字典项")
public class DictItem {
    @ApiModelProperty(value = "实际值", position = 1)
    private String value;
    @ApiModelProperty(value = "显示内容", position = 2)
    private String label;
    @ApiModelProperty(value = "上级", position = 3)
    private String parent;
}
